library(writexl)
library(readxl)
library(dplyr)
library(lattice)

#Pie Chart 1 (Gender)
p<-OverallData$Gender
count<-(table(p))
count
a<-paste(names(table(p)),round((table(p)/64)*100,digits = 2),"%")
pie(count,labels=a,col=c("Orange","SkyBlue"),main="Gender of Respondents Involved In The Survey")

#Stem and Leaf 1
x<-OverallData$`Your Age`
stem(x)

#Scatter Plot 1
plot(OverallData$`Your Age`,OverallData$`How much time do you spend every time you shop ONLINE?`,xlab="Respondents' Ages",ylab="Time Spent In Online Shopping (minutes)",main = "Scatter Plot on Respondents' Ages and Time Spending In Online Shopping")

#Comparative Bar Chart 1(use Data1CSV)
data1 <- read.csv(file.choose() , header = TRUE)
barplot(data1 ,beside = TRUE , legend = data1$Type.of.Shopping)
library(lattice)
babe = c("darkslateblue","cyan1")
barchart(
  data = data1 ,
  Number.of.Data ~ Category ,
  groups = Type.of.Shopping ,
  main = list(
    label = "Comparison of Shopping Categories of Online and Offline Shopping" ,
    cex = 2.5 
  ),
  xlab = list("Categories" ,cex =2) ,
  ylab = list ("Number of Data" ,cex = 2) ,
  scales = list (
    x = list (cex = 1.25),
    y = list (cex = 2)
  ),
  auto.key = list (
    cex = 2.0
  ),
  par.settings = list(superpose.polygon = list(col = babe)),
)

#Comparative Bar Chart 2(use FoodDeliveryCSV)
data2 <- read.csv(file.choose() , header = TRUE)
barplot(data1 ,beside = TRUE , legend = data1$Type.of.Shopping)
library(lattice)
babe = c("#6E6E6DFF","#FAD0C9FF")
barchart(
  data = data2 ,
  Number.of.Data ~ Spendings ,
  groups = Type.of.Shopping ,
  main = list(
    label = "Comparison of Spending on Food of Online and Offline Shopping" ,
    cex = 2.5 
  ),
  xlab = list("Spendings on Food" ,cex =2) ,
  ylab = list ("Number of Data" ,cex = 2) ,
  scales = list (
    x = list (cex = 1.75),
    y = list (cex = 2)
  ),
  auto.key = list (
    cex = 2.0
  ),
  origin = 0 ,
  par.settings = list(superpose.polygon = list(col = babe)),
)

#Histogram 1
hist(A$...2, main = "Overall spending on online shopping for a month", xlab = "Amount (RM)", ylab = "Frequency", breaks = c(0, 100, 200, 300, 400, 500, 800), col = "pink", freq = T, ylim = c(0, 50))

#Histogram 2
hist(A$...4, main = "Overall spending for offline shopping for a month", breaks = c(0, 150, 300, 450, 600, 750), xlab = "Amount (RM)", ylab = "Frequency", ylim = c(0,30), col = "purple")

#Box Plot 1
y<-OverallData$`How much time do you spend every time you shop ONLINE?`
boxplot(y,horizontal=T,main="Boxplot of Time Spending In Online Shopping ", xlab="Time Spending (minutes)",col=c("pink"))
summary(y)
IQR(y)
sum(y)

#Table3- Frequency Table (Question 1)
Q1 <- Question$Question1
T1 <- table(Q1)
names(T1) <- c("1 (Strongly disagree)", "2 (Disagree)", "3 (Neutral)", "4 (Agree)", "5 (Strongly Agree)")
df1 <- data.frame(T1)
names(df1) <- c("Rate", "Frequency")
write_xlsx(df1,"C:\\Users\\User\\Desktop\\PSDA project\\Rate\\Q1Table.xlsx")

#Bar Chart 1
rating1.freq = table(A[, 6])
barplot(rating1.freq[c(5,2,3,1,4)], ylim = c(0,25), xlab = "Rating", ylab = "Frequency", main = "Online Shopping is Cheaper", col = "turquoise")

#Table 4-Frequency Table (Question 2)
Q2 <- Question$Question2
T2 <- table(Q2)
names(T2) <- c("1 (Strongly disagree)", "2 (Disagree)", "3 (Neutral)", "4 (Agree)", "5 (Strongly Agree)")
df2 <- data.frame(T2)
names(df2) <- c("Rate", "Frequency")
write_xlsx(df2,"C:\\Users\\User\\Desktop\\PSDA project\\Rate\\Q2Table.xlsx")

#Bar Chart 2
rating2.freq = table(A[, 8])
barplot(rating2.freq[c(5,2,3,1,4)], xlab = "Rating", ylab = "Frequency", main = "Online Shopping has more variaties of products", col = "cornflowerblue")

#Table 5-Frequency Table (Question 3)
Q3 <- Question$Question3
T3 <- table(Q3)
names(T3) <- c("1 (Strongly disagree)", "2 (Disagree)", "3 (Neutral)", "4 (Agree)", "5 (Strongly Agree)")
df3 <- data.frame(T3)
names(df3) <- c("Rate", "Frequency")
write_xlsx(df3,"C:\\Users\\User\\Desktop\\PSDA project\\Rate\\Q3Table.xlsx")

#Bar Chart 3
rating3.freq = table(A[, 10])
barplot(rating3.freq[c(5,2,3,1,4)], xlab = "Rating", ylab = "Frequency", main = "Online Shopping is more convenient", col = "mediumorchid2")

#Table 6-Frequency Table (Question 4)
Q4 <- Question$Question4
T4 <- table(Q4)
names(T4) <- c("1 (Strongly disagree)", "2 (Disagree)", "3 (Neutral)", "4 (Agree)", "5 (Strongly Agree)")
df4 <- data.frame(T4)
names(df4) <- c("Rate", "Frequency")
write_xlsx(df4,"C:\\Users\\User\\Desktop\\PSDA project\\Rate\\Q4Table.xlsx")

#Bar Chart 4
rating4.freq = table(A[, 12])
barplot(rating4.freq[c(5,2,3,1,4)], xlab = "Rating", ylab = "Frequency", main = "Quality of offline products can be assured but online products can't", col = "slategray2")


#Table 7-Frequency Table (Question 5)
Q5 <- Question$Question5
T5 <- table(Q5)
names(T5) <- c("1 (Strongly disagree)", "2 (Disagree)", "3 (Neutral)", "4 (Agree)", "5 (Strongly Agree)")
df5 <- data.frame(T5)
names(df5) <- c("Rate", "Frequency")
write_xlsx(df5,"C:\\Users\\User\\Desktop\\PSDA project\\Rate\\Q5Table.xlsx")

#Bar Chart 5
rating5.freq = table(A[, 14])
barplot(rating5.freq[c(5,2,3,1,4)], xlab = "Rating", ylab = "Frequency", main = "Online Shopping is as secured as offline shopping", col = "peachpuff3")

#Table 8-Frequency Table (Question 6)
Q6 <- Question$Question6
T6 <- table(Q6)
names(T6) <- c("1 (Strongly disagree)", "2 (Disagree)", "3 (Neutral)", "4 (Agree)", "5 (Strongly Agree)")
df6 <- data.frame(T6)
names(df6) <- c("Rate", "Frequency")
write_xlsx(df6,"C:\\Users\\User\\Desktop\\PSDA project\\Rate\\Q6Table.xlsx")

#Bar Chart 6
rating6.freq = table(A[, 16])
barplot(rating6.freq[c(5,2,3,1,4)], xlab = "Rating", ylab = "Frequency", main = "Online Shopping will replace offline shopping in the future", col = "chartreuse3")

#Pie Chart 2 (Method only)
View(OverallData$`Which method of shopping do you prefer?`)
var1 <- OverallData$`Which method of shopping do you prefer?`
cnt <- table(var1)
cnt
numData <- nrow(OverallData)
lbls <- paste((names(table(var1))), "(", table(var1), "students /", round((table(var1)/numData)*100, digits = 2), "%)")
pie(cnt, labels = lbls, col = c("Purple", "Light Blue", "Pink"), main = "Method of shopping used by UTM students")

#Pie Chart 3 (Gender x Methods)
var1 <-Data
cnt <- t(table(var1))
numData <- nrow(Data)
lbls <- paste(round(cnt/numData*100, digits = 2), "%")
pie(cnt,
    labels = lbls,
    col = c("darkorange2", "orange", "gold", "skyblue", "lightblue", "lightcyan"),
    main = "Methods of shopping preferred by both gender")
legend(-3, -0.1,
       title = "Orange = Female",
       legend = c("Both", "Offline", "Online"), 
       fill = c("darkorange2","orange","gold"), 
       text.font = 4,
       cex = 0.8,
       box.lty = 4)
legend(1.7, -0.1,
       title = "Blue = Male",
       legend = c("Both", "Offline", "Online"), 
       fill = c("skyblue", "lightblue", "lightcyan"), 
       text.font = 4,
       cex = 0.8,
       box.lty = 4)


#Pie Chart 4 (Male -> Methods)
View(Data_Male)
var1 <- Data_Male$Methods
cnt <- table(var1)
cnt
numData <- nrow(Data_Male)
lbls <- paste(names(table(var1)), round((table(var1)/numData)*100, digits = 2), "%")
pie(cnt, labels = lbls, col = c("skyblue", "lightblue", "lightcyan"), main = "Methods of shopping preferred by Male")

#Pie Chart 5 (Female -> Methods)
View(Data_Female)
var1 <- Data_Female$Methods
cnt <- table(var1)
cnt
numData <- nrow(Data_Female)
lbls <- paste(names(table(var1)), (table(var1)/numData*100), "%")
pie(cnt, labels = lbls, col = c("darkorange2","orange","gold"), main = "Methods of shopping preferred by female")


#Bar Chart 7
barchart(
  data = Online1100 ,
  Frequency ~ Categories ,
  main = list(
    label = "Categories spent of Students with Overall Amount of RM 1- RM 100 in Online Shopping" ,
    cex = 2
  ),
  xlab = list("Categories" ,cex =2) ,
  ylab = list ("Number of Data" ,cex = 2) ,
  scales = list (
    x = list (cex = 1.25),
    y = list (cex = 2)
  ),
)

#Pie Chart 6 (Online RM1-RM100)
p<-OnlineGenderPie$Gender
count<-(table(p))
count
a<-paste(names(table(p)),round((table(p)/20)*100,digits = 2),"%")
pie(count,labels=a,col=c("Orange","SkyBlue"),main="Gender of Respondents Who Choose Fashion Accessories Category under Overall Online Shopping (RM1-RM100)")

#Bar Chart 8
library (lattice)
barchart(
  data = offline1150 ,
  Frequency ~ Categories ,
  main = list(
    label = "Categories spent of Student with the Average Spending of RM 1 - RM 150 in Offline Shopping" ,
    cex = 2
  ),
  xlab = list("Categories" ,cex =2) ,
  ylab = list ("Number of Data" ,cex = 2) ,
  scales = list (
    x = list (cex = 1.25),
    y = list (cex = 2)
  ),
  col = c(rainbow(9))
)

#Pie Chart 7 (Offline RM1-RM150)
p<-OfflineGenderPie$Gender
count<-(table(p))
count
a<-paste(names(table(p)),round((table(p)/14)*100,digits = 2),"%")
pie(count,labels=a,col=c("Orange","SkyBlue"),main="Gender of Respondents Who Choose Fashion Accessories Category under Overall Offline Shopping (RM1-RM150)")

